package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAssessmentStatusResponse(
    assessment: Optional[zio.aws.auditmanager.model.Assessment] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse = {
    import UpdateAssessmentStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse
      .builder()
      .optionallyWith(assessment.map(value => value.buildAwsValue()))(
        _.assessment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentStatusResponse
      .wrap(buildAwsValue())
}
object UpdateAssessmentStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UpdateAssessmentStatusResponse =
      zio.aws.auditmanager.model.UpdateAssessmentStatusResponse(
        assessment.map(value => value.asEditable)
      )
    def assessment: Optional[zio.aws.auditmanager.model.Assessment.ReadOnly]
    def getAssessment
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Assessment.ReadOnly] =
      AwsError.unwrapOptionField("assessment", assessment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse
  ) extends zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.ReadOnly {
    override val assessment
        : Optional[zio.aws.auditmanager.model.Assessment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessment())
        .map(value => zio.aws.auditmanager.model.Assessment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusResponse
  ): zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.ReadOnly =
    new Wrapper(impl)
}
