package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssessmentReportsResponse(
    assessmentReports: Optional[
      Iterable[zio.aws.auditmanager.model.AssessmentReportMetadata]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse = {
    import ListAssessmentReportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse
      .builder()
      .optionallyWith(
        assessmentReports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assessmentReports)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListAssessmentReportsResponse.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentReportsResponse
      .wrap(buildAwsValue())
}
object ListAssessmentReportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ListAssessmentReportsResponse =
      zio.aws.auditmanager.model.ListAssessmentReportsResponse(
        assessmentReports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def assessmentReports: Optional[
      List[zio.aws.auditmanager.model.AssessmentReportMetadata.ReadOnly]
    ]
    def nextToken: Optional[Token]
    def getAssessmentReports: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AssessmentReportMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("assessmentReports", assessmentReports)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse
  ) extends zio.aws.auditmanager.model.ListAssessmentReportsResponse.ReadOnly {
    override val assessmentReports: Optional[
      List[zio.aws.auditmanager.model.AssessmentReportMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentReports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AssessmentReportMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsResponse
  ): zio.aws.auditmanager.model.ListAssessmentReportsResponse.ReadOnly =
    new Wrapper(impl)
}
