package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class GetAssessmentReportUrlRequest(
    assessmentReportId: UUID,
    assessmentId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlRequest = {
    import GetAssessmentReportUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlRequest
      .builder()
      .assessmentReportId(UUID.unwrap(assessmentReportId): java.lang.String)
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetAssessmentReportUrlRequest.ReadOnly =
    zio.aws.auditmanager.model.GetAssessmentReportUrlRequest
      .wrap(buildAwsValue())
}
object GetAssessmentReportUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetAssessmentReportUrlRequest =
      zio.aws.auditmanager.model
        .GetAssessmentReportUrlRequest(assessmentReportId, assessmentId)
    def assessmentReportId: UUID
    def assessmentId: UUID
    def getAssessmentReportId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(assessmentReportId)
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlRequest
  ) extends zio.aws.auditmanager.model.GetAssessmentReportUrlRequest.ReadOnly {
    override val assessmentReportId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentReportId())
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlRequest
  ): zio.aws.auditmanager.model.GetAssessmentReportUrlRequest.ReadOnly =
    new Wrapper(impl)
}
