package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class UpdateAssessmentStatusRequest(
    assessmentId: UUID,
    status: zio.aws.auditmanager.model.AssessmentStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusRequest = {
    import UpdateAssessmentStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentStatusRequest.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentStatusRequest
      .wrap(buildAwsValue())
}
object UpdateAssessmentStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UpdateAssessmentStatusRequest =
      zio.aws.auditmanager.model
        .UpdateAssessmentStatusRequest(assessmentId, status)
    def assessmentId: UUID
    def status: zio.aws.auditmanager.model.AssessmentStatus
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.auditmanager.model.AssessmentStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusRequest
  ) extends zio.aws.auditmanager.model.UpdateAssessmentStatusRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val status: zio.aws.auditmanager.model.AssessmentStatus =
      zio.aws.auditmanager.model.AssessmentStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusRequest
  ): zio.aws.auditmanager.model.UpdateAssessmentStatusRequest.ReadOnly =
    new Wrapper(impl)
}
