package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{UrlLink, HyperlinkName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class URL(
    hyperlinkName: Optional[HyperlinkName] = Optional.Absent,
    link: Optional[UrlLink] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.URL = {
    import URL.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.URL
      .builder()
      .optionallyWith(
        hyperlinkName.map(value =>
          HyperlinkName.unwrap(value): java.lang.String
        )
      )(_.hyperlinkName)
      .optionallyWith(
        link.map(value => UrlLink.unwrap(value): java.lang.String)
      )(_.link)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.URL.ReadOnly =
    zio.aws.auditmanager.model.URL.wrap(buildAwsValue())
}
object URL {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.auditmanager.model.URL] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.URL = zio.aws.auditmanager.model
      .URL(hyperlinkName.map(value => value), link.map(value => value))
    def hyperlinkName: Optional[HyperlinkName]
    def link: Optional[UrlLink]
    def getHyperlinkName: ZIO[Any, AwsError, HyperlinkName] =
      AwsError.unwrapOptionField("hyperlinkName", hyperlinkName)
    def getLink: ZIO[Any, AwsError, UrlLink] =
      AwsError.unwrapOptionField("link", link)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.URL
  ) extends zio.aws.auditmanager.model.URL.ReadOnly {
    override val hyperlinkName: Optional[HyperlinkName] = zio.aws.core.internal
      .optionalFromNullable(impl.hyperlinkName())
      .map(value => zio.aws.auditmanager.model.primitives.HyperlinkName(value))
    override val link: Optional[UrlLink] = zio.aws.core.internal
      .optionalFromNullable(impl.link())
      .map(value => zio.aws.auditmanager.model.primitives.UrlLink(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.URL
  ): zio.aws.auditmanager.model.URL.ReadOnly = new Wrapper(impl)
}
