package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssessmentFrameworkShareRequestsResponse(
    assessmentFrameworkShareRequests: Optional[
      Iterable[zio.aws.auditmanager.model.AssessmentFrameworkShareRequest]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse = {
    import ListAssessmentFrameworkShareRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
      .builder()
      .optionallyWith(
        assessmentFrameworkShareRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assessmentFrameworkShareRequests)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
      .wrap(buildAwsValue())
}
object ListAssessmentFrameworkShareRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse =
      zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse(
        assessmentFrameworkShareRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def assessmentFrameworkShareRequests: Optional[
      List[zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly]
    ]
    def nextToken: Optional[Token]
    def getAssessmentFrameworkShareRequests: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "assessmentFrameworkShareRequests",
      assessmentFrameworkShareRequests
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
  ) extends zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.ReadOnly {
    override val assessmentFrameworkShareRequests: Optional[
      List[zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentFrameworkShareRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
  ): zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.ReadOnly =
    new Wrapper(impl)
}
