package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class GetAssessmentRequest(assessmentId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetAssessmentRequest = {
    import GetAssessmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetAssessmentRequest.ReadOnly =
    zio.aws.auditmanager.model.GetAssessmentRequest.wrap(buildAwsValue())
}
object GetAssessmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetAssessmentRequest =
      zio.aws.auditmanager.model.GetAssessmentRequest(assessmentId)
    def assessmentId: UUID
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentRequest
  ) extends zio.aws.auditmanager.model.GetAssessmentRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentRequest
  ): zio.aws.auditmanager.model.GetAssessmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
