package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class DeleteAssessmentRequest(assessmentId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentRequest = {
    import DeleteAssessmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.DeleteAssessmentRequest.ReadOnly =
    zio.aws.auditmanager.model.DeleteAssessmentRequest.wrap(buildAwsValue())
}
object DeleteAssessmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.DeleteAssessmentRequest =
      zio.aws.auditmanager.model.DeleteAssessmentRequest(assessmentId)
    def assessmentId: UUID
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentRequest
  ) extends zio.aws.auditmanager.model.DeleteAssessmentRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentRequest
  ): zio.aws.auditmanager.model.DeleteAssessmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
