package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  FrameworkName,
  TagValue,
  FrameworkDescription,
  ComplianceType,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAssessmentFrameworkRequest(
    name: FrameworkName,
    description: Optional[FrameworkDescription] = Optional.Absent,
    complianceType: Optional[ComplianceType] = Optional.Absent,
    controlSets: Iterable[
      zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet
    ],
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkRequest = {
    import CreateAssessmentFrameworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkRequest
      .builder()
      .name(FrameworkName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        complianceType.map(value =>
          ComplianceType.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .controlSets(controlSets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.CreateAssessmentFrameworkRequest.ReadOnly =
    zio.aws.auditmanager.model.CreateAssessmentFrameworkRequest
      .wrap(buildAwsValue())
}
object CreateAssessmentFrameworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.CreateAssessmentFrameworkRequest =
      zio.aws.auditmanager.model.CreateAssessmentFrameworkRequest(
        name,
        description.map(value => value),
        complianceType.map(value => value),
        controlSets.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def name: FrameworkName
    def description: Optional[FrameworkDescription]
    def complianceType: Optional[ComplianceType]
    def controlSets: List[
      zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet.ReadOnly
    ]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, FrameworkName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("description", description)
    def getComplianceType: ZIO[Any, AwsError, ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getControlSets: ZIO[Any, Nothing, List[
      zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet.ReadOnly
    ]] = ZIO.succeed(controlSets)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkRequest
  ) extends zio.aws.auditmanager.model.CreateAssessmentFrameworkRequest.ReadOnly {
    override val name: FrameworkName =
      zio.aws.auditmanager.model.primitives.FrameworkName(impl.name())
    override val description: Optional[FrameworkDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.auditmanager.model.primitives.FrameworkDescription(value)
        )
    override val complianceType: Optional[ComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ComplianceType(value)
        )
    override val controlSets: List[
      zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet.ReadOnly
    ] = impl
      .controlSets()
      .asScala
      .map { item =>
        zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet
          .wrap(item)
      }
      .toList
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.auditmanager.model.primitives.TagKey(
              key
            ) -> zio.aws.auditmanager.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkRequest
  ): zio.aws.auditmanager.model.CreateAssessmentFrameworkRequest.ReadOnly =
    new Wrapper(impl)
}
