package zio.aws.auditmanager.model
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{MaxResults, Token}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAssessmentsRequest(
    status: Optional[zio.aws.auditmanager.model.AssessmentStatus] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest = {
    import ListAssessmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ListAssessmentsRequest.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentsRequest.wrap(buildAwsValue())
}
object ListAssessmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ListAssessmentsRequest =
      zio.aws.auditmanager.model.ListAssessmentsRequest(
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def status: Optional[zio.aws.auditmanager.model.AssessmentStatus]
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.AssessmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest
  ) extends zio.aws.auditmanager.model.ListAssessmentsRequest.ReadOnly {
    override val status: Optional[zio.aws.auditmanager.model.AssessmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.auditmanager.model.AssessmentStatus.wrap(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest
  ): zio.aws.auditmanager.model.ListAssessmentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
