package zio.aws.auditmanager.model
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  MaxResults,
  Token,
  ControlSetId,
  UUID
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetChangeLogsRequest(
    assessmentId: UUID,
    controlSetId: Optional[ControlSetId] = Optional.Absent,
    controlId: Optional[UUID] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest = {
    import GetChangeLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .optionallyWith(
        controlSetId.map(value => ControlSetId.unwrap(value): java.lang.String)
      )(_.controlSetId)
      .optionallyWith(
        controlId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.controlId)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetChangeLogsRequest.ReadOnly =
    zio.aws.auditmanager.model.GetChangeLogsRequest.wrap(buildAwsValue())
}
object GetChangeLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetChangeLogsRequest =
      zio.aws.auditmanager.model.GetChangeLogsRequest(
        assessmentId,
        controlSetId.map(value => value),
        controlId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assessmentId: UUID
    def controlSetId: Optional[ControlSetId]
    def controlId: Optional[UUID]
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getControlSetId: ZIO[Any, AwsError, ControlSetId] =
      AwsError.unwrapOptionField("controlSetId", controlSetId)
    def getControlId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("controlId", controlId)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest
  ) extends zio.aws.auditmanager.model.GetChangeLogsRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val controlSetId: Optional[ControlSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.controlSetId())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetId(value))
    override val controlId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.controlId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest
  ): zio.aws.auditmanager.model.GetChangeLogsRequest.ReadOnly = new Wrapper(
    impl
  )
}
