package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class GetInsightsByAssessmentRequest(assessmentId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentRequest = {
    import GetInsightsByAssessmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetInsightsByAssessmentRequest.ReadOnly =
    zio.aws.auditmanager.model.GetInsightsByAssessmentRequest
      .wrap(buildAwsValue())
}
object GetInsightsByAssessmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetInsightsByAssessmentRequest =
      zio.aws.auditmanager.model.GetInsightsByAssessmentRequest(assessmentId)
    def assessmentId: UUID
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentRequest
  ) extends zio.aws.auditmanager.model.GetInsightsByAssessmentRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentRequest
  ): zio.aws.auditmanager.model.GetInsightsByAssessmentRequest.ReadOnly =
    new Wrapper(impl)
}
