package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait FrameworkType {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.FrameworkType
}
object FrameworkType {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.FrameworkType
  ): zio.aws.auditmanager.model.FrameworkType = value match {
    case software.amazon.awssdk.services.auditmanager.model.FrameworkType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.FrameworkType.STANDARD =>
      val r = Standard
      r
    case software.amazon.awssdk.services.auditmanager.model.FrameworkType.CUSTOM =>
      val r = Custom
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.FrameworkType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.FrameworkType =
      software.amazon.awssdk.services.auditmanager.model.FrameworkType.UNKNOWN_TO_SDK_VERSION
  }
  case object Standard extends zio.aws.auditmanager.model.FrameworkType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.FrameworkType =
      software.amazon.awssdk.services.auditmanager.model.FrameworkType.STANDARD
  }
  case object Custom extends zio.aws.auditmanager.model.FrameworkType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.FrameworkType =
      software.amazon.awssdk.services.auditmanager.model.FrameworkType.CUSTOM
  }
}
