package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{AuditManagerArn, UUID}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssessmentFramework(
    id: Optional[UUID] = Optional.Absent,
    arn: Optional[AuditManagerArn] = Optional.Absent,
    metadata: Optional[zio.aws.auditmanager.model.FrameworkMetadata] =
      Optional.Absent,
    controlSets: Optional[
      Iterable[zio.aws.auditmanager.model.AssessmentControlSet]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentFramework = {
    import AssessmentFramework.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentFramework
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        arn.map(value => AuditManagerArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .optionallyWith(
        controlSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlSets)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AssessmentFramework.ReadOnly =
    zio.aws.auditmanager.model.AssessmentFramework.wrap(buildAwsValue())
}
object AssessmentFramework {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentFramework
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentFramework =
      zio.aws.auditmanager.model.AssessmentFramework(
        id.map(value => value),
        arn.map(value => value),
        metadata.map(value => value.asEditable),
        controlSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Optional[UUID]
    def arn: Optional[AuditManagerArn]
    def metadata
        : Optional[zio.aws.auditmanager.model.FrameworkMetadata.ReadOnly]
    def controlSets: Optional[
      List[zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly]
    ]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, AuditManagerArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.FrameworkMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadata)
    def getControlSets: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly
    ]] = AwsError.unwrapOptionField("controlSets", controlSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentFramework
  ) extends zio.aws.auditmanager.model.AssessmentFramework.ReadOnly {
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val arn: Optional[AuditManagerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AuditManagerArn(value)
      )
    override val metadata
        : Optional[zio.aws.auditmanager.model.FrameworkMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value => zio.aws.auditmanager.model.FrameworkMetadata.wrap(value))
    override val controlSets: Optional[
      List[zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.controlSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AssessmentControlSet.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentFramework
  ): zio.aws.auditmanager.model.AssessmentFramework.ReadOnly = new Wrapper(impl)
}
