package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait SettingAttribute {
  def unwrap
      : software.amazon.awssdk.services.auditmanager.model.SettingAttribute
}
object SettingAttribute {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.SettingAttribute
  ): zio.aws.auditmanager.model.SettingAttribute = value match {
    case software.amazon.awssdk.services.auditmanager.model.SettingAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.SettingAttribute.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.auditmanager.model.SettingAttribute.IS_AWS_ORG_ENABLED =>
      val r = IS_AWS_ORG_ENABLED
      r
    case software.amazon.awssdk.services.auditmanager.model.SettingAttribute.SNS_TOPIC =>
      val r = SNS_TOPIC
      r
    case software.amazon.awssdk.services.auditmanager.model.SettingAttribute.DEFAULT_ASSESSMENT_REPORTS_DESTINATION =>
      val r = DEFAULT_ASSESSMENT_REPORTS_DESTINATION
      r
    case software.amazon.awssdk.services.auditmanager.model.SettingAttribute.DEFAULT_PROCESS_OWNERS =>
      val r = DEFAULT_PROCESS_OWNERS
      r
    case software.amazon.awssdk.services.auditmanager.model.SettingAttribute.EVIDENCE_FINDER_ENABLEMENT =>
      val r = EVIDENCE_FINDER_ENABLEMENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.SettingAttribute {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SettingAttribute =
      software.amazon.awssdk.services.auditmanager.model.SettingAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.auditmanager.model.SettingAttribute {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SettingAttribute =
      software.amazon.awssdk.services.auditmanager.model.SettingAttribute.ALL
  }
  case object IS_AWS_ORG_ENABLED
      extends zio.aws.auditmanager.model.SettingAttribute {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SettingAttribute =
      software.amazon.awssdk.services.auditmanager.model.SettingAttribute.IS_AWS_ORG_ENABLED
  }
  case object SNS_TOPIC extends zio.aws.auditmanager.model.SettingAttribute {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SettingAttribute =
      software.amazon.awssdk.services.auditmanager.model.SettingAttribute.SNS_TOPIC
  }
  case object DEFAULT_ASSESSMENT_REPORTS_DESTINATION
      extends zio.aws.auditmanager.model.SettingAttribute {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SettingAttribute =
      software.amazon.awssdk.services.auditmanager.model.SettingAttribute.DEFAULT_ASSESSMENT_REPORTS_DESTINATION
  }
  case object DEFAULT_PROCESS_OWNERS
      extends zio.aws.auditmanager.model.SettingAttribute {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SettingAttribute =
      software.amazon.awssdk.services.auditmanager.model.SettingAttribute.DEFAULT_PROCESS_OWNERS
  }
  case object EVIDENCE_FINDER_ENABLEMENT
      extends zio.aws.auditmanager.model.SettingAttribute {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SettingAttribute =
      software.amazon.awssdk.services.auditmanager.model.SettingAttribute.EVIDENCE_FINDER_ENABLEMENT
  }
}
