package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{NonEmptyString, AWSServiceName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceMetadata(
    name: Optional[AWSServiceName] = Optional.Absent,
    displayName: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    category: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ServiceMetadata = {
    import ServiceMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ServiceMetadata
      .builder()
      .optionallyWith(
        name.map(value => AWSServiceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        displayName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        category.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.category)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ServiceMetadata.ReadOnly =
    zio.aws.auditmanager.model.ServiceMetadata.wrap(buildAwsValue())
}
object ServiceMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ServiceMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ServiceMetadata =
      zio.aws.auditmanager.model.ServiceMetadata(
        name.map(value => value),
        displayName.map(value => value),
        description.map(value => value),
        category.map(value => value)
      )
    def name: Optional[AWSServiceName]
    def displayName: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def category: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, AWSServiceName] =
      AwsError.unwrapOptionField("name", name)
    def getDisplayName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getCategory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("category", category)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ServiceMetadata
  ) extends zio.aws.auditmanager.model.ServiceMetadata.ReadOnly {
    override val name: Optional[AWSServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.AWSServiceName(value))
    override val displayName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val category: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.category())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ServiceMetadata
  ): zio.aws.auditmanager.model.ServiceMetadata.ReadOnly = new Wrapper(impl)
}
