package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListNotificationsResponse(
    notifications: Optional[Iterable[zio.aws.auditmanager.model.Notification]] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse = {
    import ListNotificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse
      .builder()
      .optionallyWith(
        notifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notifications)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListNotificationsResponse.ReadOnly =
    zio.aws.auditmanager.model.ListNotificationsResponse.wrap(buildAwsValue())
}
object ListNotificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ListNotificationsResponse =
      zio.aws.auditmanager.model.ListNotificationsResponse(
        notifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def notifications
        : Optional[List[zio.aws.auditmanager.model.Notification.ReadOnly]]
    def nextToken: Optional[Token]
    def getNotifications: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Notification.ReadOnly
    ]] = AwsError.unwrapOptionField("notifications", notifications)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse
  ) extends zio.aws.auditmanager.model.ListNotificationsResponse.ReadOnly {
    override val notifications
        : Optional[List[zio.aws.auditmanager.model.Notification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Notification.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse
  ): zio.aws.auditmanager.model.ListNotificationsResponse.ReadOnly =
    new Wrapper(impl)
}
