package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{Timestamp, NullableInteger}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Insights(
    activeAssessmentsCount: Optional[NullableInteger] = Optional.Absent,
    noncompliantEvidenceCount: Optional[NullableInteger] = Optional.Absent,
    compliantEvidenceCount: Optional[NullableInteger] = Optional.Absent,
    inconclusiveEvidenceCount: Optional[NullableInteger] = Optional.Absent,
    assessmentControlsCountByNoncompliantEvidence: Optional[NullableInteger] =
      Optional.Absent,
    totalAssessmentControlsCount: Optional[NullableInteger] = Optional.Absent,
    lastUpdated: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Insights = {
    import Insights.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Insights
      .builder()
      .optionallyWith(activeAssessmentsCount.map(value => value: Integer))(
        _.activeAssessmentsCount
      )
      .optionallyWith(noncompliantEvidenceCount.map(value => value: Integer))(
        _.noncompliantEvidenceCount
      )
      .optionallyWith(compliantEvidenceCount.map(value => value: Integer))(
        _.compliantEvidenceCount
      )
      .optionallyWith(inconclusiveEvidenceCount.map(value => value: Integer))(
        _.inconclusiveEvidenceCount
      )
      .optionallyWith(
        assessmentControlsCountByNoncompliantEvidence.map(value =>
          value: Integer
        )
      )(_.assessmentControlsCountByNoncompliantEvidence)
      .optionallyWith(
        totalAssessmentControlsCount.map(value => value: Integer)
      )(_.totalAssessmentControlsCount)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Insights.ReadOnly =
    zio.aws.auditmanager.model.Insights.wrap(buildAwsValue())
}
object Insights {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Insights
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Insights =
      zio.aws.auditmanager.model.Insights(
        activeAssessmentsCount.map(value => value),
        noncompliantEvidenceCount.map(value => value),
        compliantEvidenceCount.map(value => value),
        inconclusiveEvidenceCount.map(value => value),
        assessmentControlsCountByNoncompliantEvidence.map(value => value),
        totalAssessmentControlsCount.map(value => value),
        lastUpdated.map(value => value)
      )
    def activeAssessmentsCount: Optional[NullableInteger]
    def noncompliantEvidenceCount: Optional[NullableInteger]
    def compliantEvidenceCount: Optional[NullableInteger]
    def inconclusiveEvidenceCount: Optional[NullableInteger]
    def assessmentControlsCountByNoncompliantEvidence: Optional[NullableInteger]
    def totalAssessmentControlsCount: Optional[NullableInteger]
    def lastUpdated: Optional[Timestamp]
    def getActiveAssessmentsCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "activeAssessmentsCount",
        activeAssessmentsCount
      )
    def getNoncompliantEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "noncompliantEvidenceCount",
        noncompliantEvidenceCount
      )
    def getCompliantEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "compliantEvidenceCount",
        compliantEvidenceCount
      )
    def getInconclusiveEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "inconclusiveEvidenceCount",
        inconclusiveEvidenceCount
      )
    def getAssessmentControlsCountByNoncompliantEvidence
        : ZIO[Any, AwsError, NullableInteger] = AwsError.unwrapOptionField(
      "assessmentControlsCountByNoncompliantEvidence",
      assessmentControlsCountByNoncompliantEvidence
    )
    def getTotalAssessmentControlsCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "totalAssessmentControlsCount",
        totalAssessmentControlsCount
      )
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Insights
  ) extends zio.aws.auditmanager.model.Insights.ReadOnly {
    override val activeAssessmentsCount: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeAssessmentsCount())
        .map(value => value: NullableInteger)
    override val noncompliantEvidenceCount: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noncompliantEvidenceCount())
        .map(value => value: NullableInteger)
    override val compliantEvidenceCount: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliantEvidenceCount())
        .map(value => value: NullableInteger)
    override val inconclusiveEvidenceCount: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inconclusiveEvidenceCount())
        .map(value => value: NullableInteger)
    override val assessmentControlsCountByNoncompliantEvidence
        : Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(
        impl.assessmentControlsCountByNoncompliantEvidence()
      )
      .map(value => value: NullableInteger)
    override val totalAssessmentControlsCount: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalAssessmentControlsCount())
        .map(value => value: NullableInteger)
    override val lastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Insights
  ): zio.aws.auditmanager.model.Insights.ReadOnly = new Wrapper(impl)
}
