package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  ControlSetId,
  AssessmentName,
  Timestamp,
  DelegationComment,
  IamArn,
  UUID,
  CreatedBy
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Delegation(
    id: Optional[UUID] = Optional.Absent,
    assessmentName: Optional[AssessmentName] = Optional.Absent,
    assessmentId: Optional[UUID] = Optional.Absent,
    status: Optional[zio.aws.auditmanager.model.DelegationStatus] =
      Optional.Absent,
    roleArn: Optional[IamArn] = Optional.Absent,
    roleType: Optional[zio.aws.auditmanager.model.RoleType] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastUpdated: Optional[Timestamp] = Optional.Absent,
    controlSetId: Optional[ControlSetId] = Optional.Absent,
    comment: Optional[DelegationComment] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Delegation = {
    import Delegation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Delegation
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        assessmentName.map(value =>
          AssessmentName.unwrap(value): java.lang.String
        )
      )(_.assessmentName)
      .optionallyWith(
        assessmentId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.assessmentId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        roleArn.map(value => IamArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(roleType.map(value => value.unwrap))(_.roleType)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        controlSetId.map(value => ControlSetId.unwrap(value): java.lang.String)
      )(_.controlSetId)
      .optionallyWith(
        comment.map(value => DelegationComment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Delegation.ReadOnly =
    zio.aws.auditmanager.model.Delegation.wrap(buildAwsValue())
}
object Delegation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Delegation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Delegation =
      zio.aws.auditmanager.model.Delegation(
        id.map(value => value),
        assessmentName.map(value => value),
        assessmentId.map(value => value),
        status.map(value => value),
        roleArn.map(value => value),
        roleType.map(value => value),
        creationTime.map(value => value),
        lastUpdated.map(value => value),
        controlSetId.map(value => value),
        comment.map(value => value),
        createdBy.map(value => value)
      )
    def id: Optional[UUID]
    def assessmentName: Optional[AssessmentName]
    def assessmentId: Optional[UUID]
    def status: Optional[zio.aws.auditmanager.model.DelegationStatus]
    def roleArn: Optional[IamArn]
    def roleType: Optional[zio.aws.auditmanager.model.RoleType]
    def creationTime: Optional[Timestamp]
    def lastUpdated: Optional[Timestamp]
    def controlSetId: Optional[ControlSetId]
    def comment: Optional[DelegationComment]
    def createdBy: Optional[CreatedBy]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getAssessmentName: ZIO[Any, AwsError, AssessmentName] =
      AwsError.unwrapOptionField("assessmentName", assessmentName)
    def getAssessmentId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("assessmentId", assessmentId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.DelegationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRoleArn: ZIO[Any, AwsError, IamArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRoleType: ZIO[Any, AwsError, zio.aws.auditmanager.model.RoleType] =
      AwsError.unwrapOptionField("roleType", roleType)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getControlSetId: ZIO[Any, AwsError, ControlSetId] =
      AwsError.unwrapOptionField("controlSetId", controlSetId)
    def getComment: ZIO[Any, AwsError, DelegationComment] =
      AwsError.unwrapOptionField("comment", comment)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Delegation
  ) extends zio.aws.auditmanager.model.Delegation.ReadOnly {
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val assessmentName: Optional[AssessmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessmentName())
        .map(value =>
          zio.aws.auditmanager.model.primitives.AssessmentName(value)
        )
    override val assessmentId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val status: Optional[zio.aws.auditmanager.model.DelegationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.auditmanager.model.DelegationStatus.wrap(value))
    override val roleArn: Optional[IamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.auditmanager.model.primitives.IamArn(value))
    override val roleType: Optional[zio.aws.auditmanager.model.RoleType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roleType())
        .map(value => zio.aws.auditmanager.model.RoleType.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val lastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val controlSetId: Optional[ControlSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.controlSetId())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetId(value))
    override val comment: Optional[DelegationComment] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value =>
        zio.aws.auditmanager.model.primitives.DelegationComment(value)
      )
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.auditmanager.model.primitives.CreatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Delegation
  ): zio.aws.auditmanager.model.Delegation.ReadOnly = new Wrapper(impl)
}
