package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait EvidenceFinderBackfillStatus {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus
}
object EvidenceFinderBackfillStatus {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus
  ): zio.aws.auditmanager.model.EvidenceFinderBackfillStatus = value match {
    case software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus.NOT_STARTED =>
      val r = NOT_STARTED
      r
    case software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.EvidenceFinderBackfillStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus =
      software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_STARTED
      extends zio.aws.auditmanager.model.EvidenceFinderBackfillStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus =
      software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus.NOT_STARTED
  }
  case object IN_PROGRESS
      extends zio.aws.auditmanager.model.EvidenceFinderBackfillStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus =
      software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus.IN_PROGRESS
  }
  case object COMPLETED
      extends zio.aws.auditmanager.model.EvidenceFinderBackfillStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus =
      software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus.COMPLETED
  }
}
