package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.GenericArn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Resource(
    arn: Optional[GenericArn] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    complianceCheck: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Resource
      .builder()
      .optionallyWith(
        arn.map(value => GenericArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(complianceCheck.map(value => value: java.lang.String))(
        _.complianceCheck
      )
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Resource.ReadOnly =
    zio.aws.auditmanager.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Resource =
      zio.aws.auditmanager.model.Resource(
        arn.map(value => value),
        value.map(value => value),
        complianceCheck.map(value => value)
      )
    def arn: Optional[GenericArn]
    def value: Optional[String]
    def complianceCheck: Optional[String]
    def getArn: ZIO[Any, AwsError, GenericArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getComplianceCheck: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("complianceCheck", complianceCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Resource
  ) extends zio.aws.auditmanager.model.Resource.ReadOnly {
    override val arn: Optional[GenericArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.auditmanager.model.primitives.GenericArn(value))
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val complianceCheck: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.complianceCheck())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Resource
  ): zio.aws.auditmanager.model.Resource.ReadOnly = new Wrapper(impl)
}
