package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  TroubleshootingText,
  SourceDescription,
  SourceName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateControlMappingSource(
    sourceName: Optional[SourceName] = Optional.Absent,
    sourceDescription: Optional[SourceDescription] = Optional.Absent,
    sourceSetUpOption: Optional[zio.aws.auditmanager.model.SourceSetUpOption] =
      Optional.Absent,
    sourceType: Optional[zio.aws.auditmanager.model.SourceType] =
      Optional.Absent,
    sourceKeyword: Optional[zio.aws.auditmanager.model.SourceKeyword] =
      Optional.Absent,
    sourceFrequency: Optional[zio.aws.auditmanager.model.SourceFrequency] =
      Optional.Absent,
    troubleshootingText: Optional[TroubleshootingText] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateControlMappingSource = {
    import CreateControlMappingSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateControlMappingSource
      .builder()
      .optionallyWith(
        sourceName.map(value => SourceName.unwrap(value): java.lang.String)
      )(_.sourceName)
      .optionallyWith(
        sourceDescription.map(value =>
          SourceDescription.unwrap(value): java.lang.String
        )
      )(_.sourceDescription)
      .optionallyWith(sourceSetUpOption.map(value => value.unwrap))(
        _.sourceSetUpOption
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(sourceKeyword.map(value => value.buildAwsValue()))(
        _.sourceKeyword
      )
      .optionallyWith(sourceFrequency.map(value => value.unwrap))(
        _.sourceFrequency
      )
      .optionallyWith(
        troubleshootingText.map(value =>
          TroubleshootingText.unwrap(value): java.lang.String
        )
      )(_.troubleshootingText)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.CreateControlMappingSource.ReadOnly =
    zio.aws.auditmanager.model.CreateControlMappingSource.wrap(buildAwsValue())
}
object CreateControlMappingSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateControlMappingSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.CreateControlMappingSource =
      zio.aws.auditmanager.model.CreateControlMappingSource(
        sourceName.map(value => value),
        sourceDescription.map(value => value),
        sourceSetUpOption.map(value => value),
        sourceType.map(value => value),
        sourceKeyword.map(value => value.asEditable),
        sourceFrequency.map(value => value),
        troubleshootingText.map(value => value)
      )
    def sourceName: Optional[SourceName]
    def sourceDescription: Optional[SourceDescription]
    def sourceSetUpOption
        : Optional[zio.aws.auditmanager.model.SourceSetUpOption]
    def sourceType: Optional[zio.aws.auditmanager.model.SourceType]
    def sourceKeyword
        : Optional[zio.aws.auditmanager.model.SourceKeyword.ReadOnly]
    def sourceFrequency: Optional[zio.aws.auditmanager.model.SourceFrequency]
    def troubleshootingText: Optional[TroubleshootingText]
    def getSourceName: ZIO[Any, AwsError, SourceName] =
      AwsError.unwrapOptionField("sourceName", sourceName)
    def getSourceDescription: ZIO[Any, AwsError, SourceDescription] =
      AwsError.unwrapOptionField("sourceDescription", sourceDescription)
    def getSourceSetUpOption
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.SourceSetUpOption] =
      AwsError.unwrapOptionField("sourceSetUpOption", sourceSetUpOption)
    def getSourceType
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceKeyword: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.SourceKeyword.ReadOnly
    ] = AwsError.unwrapOptionField("sourceKeyword", sourceKeyword)
    def getSourceFrequency
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.SourceFrequency] =
      AwsError.unwrapOptionField("sourceFrequency", sourceFrequency)
    def getTroubleshootingText: ZIO[Any, AwsError, TroubleshootingText] =
      AwsError.unwrapOptionField("troubleshootingText", troubleshootingText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateControlMappingSource
  ) extends zio.aws.auditmanager.model.CreateControlMappingSource.ReadOnly {
    override val sourceName: Optional[SourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceName())
      .map(value => zio.aws.auditmanager.model.primitives.SourceName(value))
    override val sourceDescription: Optional[SourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDescription())
        .map(value =>
          zio.aws.auditmanager.model.primitives.SourceDescription(value)
        )
    override val sourceSetUpOption
        : Optional[zio.aws.auditmanager.model.SourceSetUpOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceSetUpOption())
        .map(value => zio.aws.auditmanager.model.SourceSetUpOption.wrap(value))
    override val sourceType: Optional[zio.aws.auditmanager.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.auditmanager.model.SourceType.wrap(value))
    override val sourceKeyword
        : Optional[zio.aws.auditmanager.model.SourceKeyword.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceKeyword())
        .map(value => zio.aws.auditmanager.model.SourceKeyword.wrap(value))
    override val sourceFrequency
        : Optional[zio.aws.auditmanager.model.SourceFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceFrequency())
        .map(value => zio.aws.auditmanager.model.SourceFrequency.wrap(value))
    override val troubleshootingText: Optional[TroubleshootingText] =
      zio.aws.core.internal
        .optionalFromNullable(impl.troubleshootingText())
        .map(value =>
          zio.aws.auditmanager.model.primitives.TroubleshootingText(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateControlMappingSource
  ): zio.aws.auditmanager.model.CreateControlMappingSource.ReadOnly =
    new Wrapper(impl)
}
