package zio.aws.auditmanager.model
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  MaxResults,
  Token,
  ControlSetId,
  UUID
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetEvidenceByEvidenceFolderRequest(
    assessmentId: UUID,
    controlSetId: ControlSetId,
    evidenceFolderId: UUID,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest = {
    import GetEvidenceByEvidenceFolderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .controlSetId(ControlSetId.unwrap(controlSetId): java.lang.String)
      .evidenceFolderId(UUID.unwrap(evidenceFolderId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderRequest.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderRequest
      .wrap(buildAwsValue())
}
object GetEvidenceByEvidenceFolderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderRequest =
      zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderRequest(
        assessmentId,
        controlSetId,
        evidenceFolderId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assessmentId: UUID
    def controlSetId: ControlSetId
    def evidenceFolderId: UUID
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getControlSetId: ZIO[Any, Nothing, ControlSetId] =
      ZIO.succeed(controlSetId)
    def getEvidenceFolderId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(evidenceFolderId)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest
  ) extends zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val controlSetId: ControlSetId =
      zio.aws.auditmanager.model.primitives.ControlSetId(impl.controlSetId())
    override val evidenceFolderId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.evidenceFolderId())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest
  ): zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderRequest.ReadOnly =
    new Wrapper(impl)
}
