package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class BatchDisassociateAssessmentReportEvidenceRequest(
    assessmentId: UUID,
    evidenceFolderId: UUID,
    evidenceIds: Iterable[UUID]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest = {
    import BatchDisassociateAssessmentReportEvidenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .evidenceFolderId(UUID.unwrap(evidenceFolderId): java.lang.String)
      .evidenceIds(evidenceIds.map { item =>
        UUID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest.ReadOnly =
    zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest
      .wrap(buildAwsValue())
}
object BatchDisassociateAssessmentReportEvidenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest =
      zio.aws.auditmanager.model
        .BatchDisassociateAssessmentReportEvidenceRequest(
          assessmentId,
          evidenceFolderId,
          evidenceIds
        )
    def assessmentId: UUID
    def evidenceFolderId: UUID
    def evidenceIds: List[UUID]
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getEvidenceFolderId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(evidenceFolderId)
    def getEvidenceIds: ZIO[Any, Nothing, List[UUID]] = ZIO.succeed(evidenceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest
  ) extends zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val evidenceFolderId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.evidenceFolderId())
    override val evidenceIds: List[UUID] = impl
      .evidenceIds()
      .asScala
      .map { item =>
        zio.aws.auditmanager.model.primitives.UUID(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest
  ): zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest.ReadOnly =
    new Wrapper(impl)
}
