package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  AccountName,
  EmailAddress,
  AccountId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AWSAccount(
    id: Optional[AccountId] = Optional.Absent,
    emailAddress: Optional[EmailAddress] = Optional.Absent,
    name: Optional[AccountName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AWSAccount = {
    import AWSAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AWSAccount
      .builder()
      .optionallyWith(
        id.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        emailAddress.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        name.map(value => AccountName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AWSAccount.ReadOnly =
    zio.aws.auditmanager.model.AWSAccount.wrap(buildAwsValue())
}
object AWSAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AWSAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AWSAccount =
      zio.aws.auditmanager.model.AWSAccount(
        id.map(value => value),
        emailAddress.map(value => value),
        name.map(value => value)
      )
    def id: Optional[AccountId]
    def emailAddress: Optional[EmailAddress]
    def name: Optional[AccountName]
    def getId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("id", id)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getName: ZIO[Any, AwsError, AccountName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AWSAccount
  ) extends zio.aws.auditmanager.model.AWSAccount.ReadOnly {
    override val id: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val emailAddress: Optional[EmailAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value => zio.aws.auditmanager.model.primitives.EmailAddress(value))
    override val name: Optional[AccountName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.AccountName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AWSAccount
  ): zio.aws.auditmanager.model.AWSAccount.ReadOnly = new Wrapper(impl)
}
