package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetServicesInScopeResponse(
    serviceMetadata: Optional[
      Iterable[zio.aws.auditmanager.model.ServiceMetadata]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse = {
    import GetServicesInScopeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse
      .builder()
      .optionallyWith(
        serviceMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetServicesInScopeResponse.ReadOnly =
    zio.aws.auditmanager.model.GetServicesInScopeResponse.wrap(buildAwsValue())
}
object GetServicesInScopeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetServicesInScopeResponse =
      zio.aws.auditmanager.model.GetServicesInScopeResponse(
        serviceMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serviceMetadata
        : Optional[List[zio.aws.auditmanager.model.ServiceMetadata.ReadOnly]]
    def getServiceMetadata: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ServiceMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceMetadata", serviceMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse
  ) extends zio.aws.auditmanager.model.GetServicesInScopeResponse.ReadOnly {
    override val serviceMetadata
        : Optional[List[zio.aws.auditmanager.model.ServiceMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.ServiceMetadata.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse
  ): zio.aws.auditmanager.model.GetServicesInScopeResponse.ReadOnly =
    new Wrapper(impl)
}
