package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEvidenceByEvidenceFolderResponse(
    evidence: Optional[Iterable[zio.aws.auditmanager.model.Evidence]] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse = {
    import GetEvidenceByEvidenceFolderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse
      .builder()
      .optionallyWith(
        evidence.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evidence)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse
      .wrap(buildAwsValue())
}
object GetEvidenceByEvidenceFolderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse =
      zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse(
        evidence.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def evidence: Optional[List[zio.aws.auditmanager.model.Evidence.ReadOnly]]
    def nextToken: Optional[Token]
    def getEvidence: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Evidence.ReadOnly
    ]] = AwsError.unwrapOptionField("evidence", evidence)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse
  ) extends zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.ReadOnly {
    override val evidence
        : Optional[List[zio.aws.auditmanager.model.Evidence.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidence())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Evidence.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse
  ): zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.ReadOnly =
    new Wrapper(impl)
}
