package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.ControlSetName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAssessmentFrameworkControlSet(
    name: ControlSetName,
    controls: Optional[
      Iterable[zio.aws.auditmanager.model.CreateAssessmentFrameworkControl]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControlSet = {
    import CreateAssessmentFrameworkControlSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControlSet
      .builder()
      .name(ControlSetName.unwrap(name): java.lang.String)
      .optionallyWith(
        controls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controls)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet.ReadOnly =
    zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet
      .wrap(buildAwsValue())
}
object CreateAssessmentFrameworkControlSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControlSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet =
      zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet(
        name,
        controls.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ControlSetName
    def controls: Optional[
      List[zio.aws.auditmanager.model.CreateAssessmentFrameworkControl.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, ControlSetName] = ZIO.succeed(name)
    def getControls: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.CreateAssessmentFrameworkControl.ReadOnly
    ]] = AwsError.unwrapOptionField("controls", controls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControlSet
  ) extends zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet.ReadOnly {
    override val name: ControlSetName =
      zio.aws.auditmanager.model.primitives.ControlSetName(impl.name())
    override val controls: Optional[
      List[zio.aws.auditmanager.model.CreateAssessmentFrameworkControl.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.controls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.CreateAssessmentFrameworkControl.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControlSet
  ): zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet.ReadOnly =
    new Wrapper(impl)
}
