package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{IamArn, Timestamp, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ChangeLog(
    objectType: Optional[zio.aws.auditmanager.model.ObjectTypeEnum] =
      Optional.Absent,
    objectName: Optional[NonEmptyString] = Optional.Absent,
    action: Optional[zio.aws.auditmanager.model.ActionEnum] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[IamArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ChangeLog = {
    import ChangeLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ChangeLog
      .builder()
      .optionallyWith(objectType.map(value => value.unwrap))(_.objectType)
      .optionallyWith(
        objectName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.objectName)
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => IamArn.unwrap(value): java.lang.String)
      )(_.createdBy)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ChangeLog.ReadOnly =
    zio.aws.auditmanager.model.ChangeLog.wrap(buildAwsValue())
}
object ChangeLog {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ChangeLog
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ChangeLog =
      zio.aws.auditmanager.model.ChangeLog(
        objectType.map(value => value),
        objectName.map(value => value),
        action.map(value => value),
        createdAt.map(value => value),
        createdBy.map(value => value)
      )
    def objectType: Optional[zio.aws.auditmanager.model.ObjectTypeEnum]
    def objectName: Optional[NonEmptyString]
    def action: Optional[zio.aws.auditmanager.model.ActionEnum]
    def createdAt: Optional[Timestamp]
    def createdBy: Optional[IamArn]
    def getObjectType
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ObjectTypeEnum] =
      AwsError.unwrapOptionField("objectType", objectType)
    def getObjectName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("objectName", objectName)
    def getAction: ZIO[Any, AwsError, zio.aws.auditmanager.model.ActionEnum] =
      AwsError.unwrapOptionField("action", action)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, IamArn] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ChangeLog
  ) extends zio.aws.auditmanager.model.ChangeLog.ReadOnly {
    override val objectType
        : Optional[zio.aws.auditmanager.model.ObjectTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectType())
        .map(value => zio.aws.auditmanager.model.ObjectTypeEnum.wrap(value))
    override val objectName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.objectName())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val action: Optional[zio.aws.auditmanager.model.ActionEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.auditmanager.model.ActionEnum.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val createdBy: Optional[IamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.auditmanager.model.primitives.IamArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ChangeLog
  ): zio.aws.auditmanager.model.ChangeLog.ReadOnly = new Wrapper(impl)
}
