package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.UUID
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDisassociateAssessmentReportEvidenceResponse(
    evidenceIds: Optional[Iterable[UUID]] = Optional.Absent,
    errors: Optional[
      Iterable[zio.aws.auditmanager.model.AssessmentReportEvidenceError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse = {
    import BatchDisassociateAssessmentReportEvidenceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse
      .builder()
      .optionallyWith(
        evidenceIds.map(value =>
          value.map { item =>
            UUID.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.evidenceIds)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse.ReadOnly =
    zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse
      .wrap(buildAwsValue())
}
object BatchDisassociateAssessmentReportEvidenceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse =
      zio.aws.auditmanager.model
        .BatchDisassociateAssessmentReportEvidenceResponse(
          evidenceIds.map(value => value),
          errors.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def evidenceIds: Optional[List[UUID]]
    def errors: Optional[
      List[zio.aws.auditmanager.model.AssessmentReportEvidenceError.ReadOnly]
    ]
    def getEvidenceIds: ZIO[Any, AwsError, List[UUID]] =
      AwsError.unwrapOptionField("evidenceIds", evidenceIds)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AssessmentReportEvidenceError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse
  ) extends zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse.ReadOnly {
    override val evidenceIds: Optional[List[UUID]] = zio.aws.core.internal
      .optionalFromNullable(impl.evidenceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.primitives.UUID(item)
        }.toList
      )
    override val errors: Optional[
      List[zio.aws.auditmanager.model.AssessmentReportEvidenceError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AssessmentReportEvidenceError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse
  ): zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse.ReadOnly =
    new Wrapper(impl)
}
