package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchImportEvidenceToAssessmentControlResponse(
    errors: Optional[Iterable[
      zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse = {
    import BatchImportEvidenceToAssessmentControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse.ReadOnly =
    zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse
      .wrap(buildAwsValue())
}
object BatchImportEvidenceToAssessmentControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse =
      zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[List[
      zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError.ReadOnly
    ]]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse
  ) extends zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse.ReadOnly {
    override val errors: Optional[List[
      zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse
  ): zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse.ReadOnly =
    new Wrapper(impl)
}
