package zio.aws.auditmanager.model
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{MaxResults, Token}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListControlDomainInsightsRequest(
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest = {
    import ListControlDomainInsightsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListControlDomainInsightsRequest.ReadOnly =
    zio.aws.auditmanager.model.ListControlDomainInsightsRequest
      .wrap(buildAwsValue())
}
object ListControlDomainInsightsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListControlDomainInsightsRequest =
      zio.aws.auditmanager.model.ListControlDomainInsightsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest
  ) extends zio.aws.auditmanager.model.ListControlDomainInsightsRequest.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest
  ): zio.aws.auditmanager.model.ListControlDomainInsightsRequest.ReadOnly =
    new Wrapper(impl)
}
