package zio.aws.auditmanager.model
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{MaxResults, Token}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListControlsRequest(
    controlType: zio.aws.auditmanager.model.ControlType,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListControlsRequest = {
    import ListControlsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListControlsRequest
      .builder()
      .controlType(controlType.unwrap)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ListControlsRequest.ReadOnly =
    zio.aws.auditmanager.model.ListControlsRequest.wrap(buildAwsValue())
}
object ListControlsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListControlsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ListControlsRequest =
      zio.aws.auditmanager.model.ListControlsRequest(
        controlType,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def controlType: zio.aws.auditmanager.model.ControlType
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def getControlType
        : ZIO[Any, Nothing, zio.aws.auditmanager.model.ControlType] =
      ZIO.succeed(controlType)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlsRequest
  ) extends zio.aws.auditmanager.model.ListControlsRequest.ReadOnly {
    override val controlType: zio.aws.auditmanager.model.ControlType =
      zio.aws.auditmanager.model.ControlType.wrap(impl.controlType())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlsRequest
  ): zio.aws.auditmanager.model.ListControlsRequest.ReadOnly = new Wrapper(impl)
}
