package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssessmentFrameworksResponse(
    frameworkMetadataList: Optional[
      Iterable[zio.aws.auditmanager.model.AssessmentFrameworkMetadata]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse = {
    import ListAssessmentFrameworksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse
      .builder()
      .optionallyWith(
        frameworkMetadataList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.frameworkMetadataList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListAssessmentFrameworksResponse.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentFrameworksResponse
      .wrap(buildAwsValue())
}
object ListAssessmentFrameworksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListAssessmentFrameworksResponse =
      zio.aws.auditmanager.model.ListAssessmentFrameworksResponse(
        frameworkMetadataList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def frameworkMetadataList: Optional[
      List[zio.aws.auditmanager.model.AssessmentFrameworkMetadata.ReadOnly]
    ]
    def nextToken: Optional[Token]
    def getFrameworkMetadataList: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AssessmentFrameworkMetadata.ReadOnly
    ]] =
      AwsError.unwrapOptionField("frameworkMetadataList", frameworkMetadataList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse
  ) extends zio.aws.auditmanager.model.ListAssessmentFrameworksResponse.ReadOnly {
    override val frameworkMetadataList: Optional[
      List[zio.aws.auditmanager.model.AssessmentFrameworkMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkMetadataList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AssessmentFrameworkMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse
  ): zio.aws.auditmanager.model.ListAssessmentFrameworksResponse.ReadOnly =
    new Wrapper(impl)
}
