package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.{TagValue, TagKey, AuditManagerArn}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: AuditManagerArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.TagResourceRequest
      .builder()
      .resourceArn(AuditManagerArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.TagResourceRequest.ReadOnly =
    zio.aws.auditmanager.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.TagResourceRequest =
      zio.aws.auditmanager.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: AuditManagerArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, AuditManagerArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.TagResourceRequest
  ) extends zio.aws.auditmanager.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AuditManagerArn =
      zio.aws.auditmanager.model.primitives.AuditManagerArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.auditmanager.model.primitives
          .TagKey(key) -> zio.aws.auditmanager.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.TagResourceRequest
  ): zio.aws.auditmanager.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
