package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEvidenceResponse(
    evidence: Optional[zio.aws.auditmanager.model.Evidence] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceResponse = {
    import GetEvidenceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceResponse
      .builder()
      .optionallyWith(evidence.map(value => value.buildAwsValue()))(_.evidence)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetEvidenceResponse.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceResponse.wrap(buildAwsValue())
}
object GetEvidenceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetEvidenceResponse =
      zio.aws.auditmanager.model
        .GetEvidenceResponse(evidence.map(value => value.asEditable))
    def evidence: Optional[zio.aws.auditmanager.model.Evidence.ReadOnly]
    def getEvidence
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Evidence.ReadOnly] =
      AwsError.unwrapOptionField("evidence", evidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceResponse
  ) extends zio.aws.auditmanager.model.GetEvidenceResponse.ReadOnly {
    override val evidence
        : Optional[zio.aws.auditmanager.model.Evidence.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidence())
        .map(value => zio.aws.auditmanager.model.Evidence.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceResponse
  ): zio.aws.auditmanager.model.GetEvidenceResponse.ReadOnly = new Wrapper(impl)
}
