package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{AccountId, KmsKey}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterAccountRequest(
    kmsKey: Optional[KmsKey] = Optional.Absent,
    delegatedAdminAccount: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.RegisterAccountRequest = {
    import RegisterAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.RegisterAccountRequest
      .builder()
      .optionallyWith(
        kmsKey.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        delegatedAdminAccount.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.delegatedAdminAccount)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.RegisterAccountRequest.ReadOnly =
    zio.aws.auditmanager.model.RegisterAccountRequest.wrap(buildAwsValue())
}
object RegisterAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.RegisterAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.RegisterAccountRequest =
      zio.aws.auditmanager.model.RegisterAccountRequest(
        kmsKey.map(value => value),
        delegatedAdminAccount.map(value => value)
      )
    def kmsKey: Optional[KmsKey]
    def delegatedAdminAccount: Optional[AccountId]
    def getKmsKey: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getDelegatedAdminAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("delegatedAdminAccount", delegatedAdminAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.RegisterAccountRequest
  ) extends zio.aws.auditmanager.model.RegisterAccountRequest.ReadOnly {
    override val kmsKey: Optional[KmsKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.auditmanager.model.primitives.KmsKey(value))
    override val delegatedAdminAccount: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.delegatedAdminAccount())
        .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.RegisterAccountRequest
  ): zio.aws.auditmanager.model.RegisterAccountRequest.ReadOnly = new Wrapper(
    impl
  )
}
