package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  UUID,
  AssessmentReportDescription,
  AssessmentReportName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAssessmentReportRequest(
    name: AssessmentReportName,
    description: Optional[AssessmentReportDescription] = Optional.Absent,
    assessmentId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportRequest = {
    import CreateAssessmentReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportRequest
      .builder()
      .name(AssessmentReportName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          AssessmentReportDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.CreateAssessmentReportRequest.ReadOnly =
    zio.aws.auditmanager.model.CreateAssessmentReportRequest
      .wrap(buildAwsValue())
}
object CreateAssessmentReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.CreateAssessmentReportRequest =
      zio.aws.auditmanager.model.CreateAssessmentReportRequest(
        name,
        description.map(value => value),
        assessmentId
      )
    def name: AssessmentReportName
    def description: Optional[AssessmentReportDescription]
    def assessmentId: UUID
    def getName: ZIO[Any, Nothing, AssessmentReportName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, AssessmentReportDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportRequest
  ) extends zio.aws.auditmanager.model.CreateAssessmentReportRequest.ReadOnly {
    override val name: AssessmentReportName =
      zio.aws.auditmanager.model.primitives.AssessmentReportName(impl.name())
    override val description: Optional[AssessmentReportDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.auditmanager.model.primitives
            .AssessmentReportDescription(value)
        )
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportRequest
  ): zio.aws.auditmanager.model.CreateAssessmentReportRequest.ReadOnly =
    new Wrapper(impl)
}
