package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  Integer,
  UUID,
  ControlDescription,
  ControlName,
  NonEmptyString
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssessmentControl(
    id: Optional[UUID] = Optional.Absent,
    name: Optional[ControlName] = Optional.Absent,
    description: Optional[ControlDescription] = Optional.Absent,
    status: Optional[zio.aws.auditmanager.model.ControlStatus] =
      Optional.Absent,
    response: Optional[zio.aws.auditmanager.model.ControlResponse] =
      Optional.Absent,
    comments: Optional[Iterable[zio.aws.auditmanager.model.ControlComment]] =
      Optional.Absent,
    evidenceSources: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    evidenceCount: Optional[Integer] = Optional.Absent,
    assessmentReportEvidenceCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentControl = {
    import AssessmentControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentControl
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => ControlName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ControlDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(response.map(value => value.unwrap))(_.response)
      .optionallyWith(
        comments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.comments)
      .optionallyWith(
        evidenceSources.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.evidenceSources)
      .optionallyWith(evidenceCount.map(value => value: java.lang.Integer))(
        _.evidenceCount
      )
      .optionallyWith(
        assessmentReportEvidenceCount.map(value => value: java.lang.Integer)
      )(_.assessmentReportEvidenceCount)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AssessmentControl.ReadOnly =
    zio.aws.auditmanager.model.AssessmentControl.wrap(buildAwsValue())
}
object AssessmentControl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentControl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentControl =
      zio.aws.auditmanager.model.AssessmentControl(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        response.map(value => value),
        comments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        evidenceSources.map(value => value),
        evidenceCount.map(value => value),
        assessmentReportEvidenceCount.map(value => value)
      )
    def id: Optional[UUID]
    def name: Optional[ControlName]
    def description: Optional[ControlDescription]
    def status: Optional[zio.aws.auditmanager.model.ControlStatus]
    def response: Optional[zio.aws.auditmanager.model.ControlResponse]
    def comments
        : Optional[List[zio.aws.auditmanager.model.ControlComment.ReadOnly]]
    def evidenceSources: Optional[List[NonEmptyString]]
    def evidenceCount: Optional[Integer]
    def assessmentReportEvidenceCount: Optional[Integer]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ControlName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ControlDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ControlStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResponse
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ControlResponse] =
      AwsError.unwrapOptionField("response", response)
    def getComments: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ControlComment.ReadOnly
    ]] = AwsError.unwrapOptionField("comments", comments)
    def getEvidenceSources: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("evidenceSources", evidenceSources)
    def getEvidenceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("evidenceCount", evidenceCount)
    def getAssessmentReportEvidenceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "assessmentReportEvidenceCount",
        assessmentReportEvidenceCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentControl
  ) extends zio.aws.auditmanager.model.AssessmentControl.ReadOnly {
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val name: Optional[ControlName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.ControlName(value))
    override val description: Optional[ControlDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ControlDescription(value)
        )
    override val status: Optional[zio.aws.auditmanager.model.ControlStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.auditmanager.model.ControlStatus.wrap(value))
    override val response
        : Optional[zio.aws.auditmanager.model.ControlResponse] =
      zio.aws.core.internal
        .optionalFromNullable(impl.response())
        .map(value => zio.aws.auditmanager.model.ControlResponse.wrap(value))
    override val comments
        : Optional[List[zio.aws.auditmanager.model.ControlComment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.ControlComment.wrap(item)
          }.toList
        )
    override val evidenceSources: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val evidenceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.evidenceCount())
      .map(value => value: Integer)
    override val assessmentReportEvidenceCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessmentReportEvidenceCount())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentControl
  ): zio.aws.auditmanager.model.AssessmentControl.ReadOnly = new Wrapper(impl)
}
