package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait AccountStatus {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.AccountStatus
}
object AccountStatus {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.AccountStatus
  ): zio.aws.auditmanager.model.AccountStatus = value match {
    case software.amazon.awssdk.services.auditmanager.model.AccountStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.AccountStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.auditmanager.model.AccountStatus.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.auditmanager.model.AccountStatus.PENDING_ACTIVATION =>
      val r = PENDING_ACTIVATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.AccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.AccountStatus =
      software.amazon.awssdk.services.auditmanager.model.AccountStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.auditmanager.model.AccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.AccountStatus =
      software.amazon.awssdk.services.auditmanager.model.AccountStatus.ACTIVE
  }
  case object INACTIVE extends zio.aws.auditmanager.model.AccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.AccountStatus =
      software.amazon.awssdk.services.auditmanager.model.AccountStatus.INACTIVE
  }
  case object PENDING_ACTIVATION
      extends zio.aws.auditmanager.model.AccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.AccountStatus =
      software.amazon.awssdk.services.auditmanager.model.AccountStatus.PENDING_ACTIVATION
  }
}
