package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.NonEmptyString
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidateAssessmentReportIntegrityResponse(
    signatureValid: Optional[Boolean] = Optional.Absent,
    signatureAlgorithm: Optional[String] = Optional.Absent,
    signatureDateTime: Optional[String] = Optional.Absent,
    signatureKeyId: Optional[String] = Optional.Absent,
    validationErrors: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityResponse = {
    import ValidateAssessmentReportIntegrityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityResponse
      .builder()
      .optionallyWith(signatureValid.map(value => value: java.lang.Boolean))(
        _.signatureValid
      )
      .optionallyWith(signatureAlgorithm.map(value => value: java.lang.String))(
        _.signatureAlgorithm
      )
      .optionallyWith(signatureDateTime.map(value => value: java.lang.String))(
        _.signatureDateTime
      )
      .optionallyWith(signatureKeyId.map(value => value: java.lang.String))(
        _.signatureKeyId
      )
      .optionallyWith(
        validationErrors.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.validationErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse.ReadOnly =
    zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse
      .wrap(buildAwsValue())
}
object ValidateAssessmentReportIntegrityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse =
      zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse(
        signatureValid.map(value => value),
        signatureAlgorithm.map(value => value),
        signatureDateTime.map(value => value),
        signatureKeyId.map(value => value),
        validationErrors.map(value => value)
      )
    def signatureValid: Optional[Boolean]
    def signatureAlgorithm: Optional[String]
    def signatureDateTime: Optional[String]
    def signatureKeyId: Optional[String]
    def validationErrors: Optional[List[NonEmptyString]]
    def getSignatureValid: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("signatureValid", signatureValid)
    def getSignatureAlgorithm: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signatureAlgorithm", signatureAlgorithm)
    def getSignatureDateTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signatureDateTime", signatureDateTime)
    def getSignatureKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signatureKeyId", signatureKeyId)
    def getValidationErrors: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("validationErrors", validationErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityResponse
  ) extends zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse.ReadOnly {
    override val signatureValid: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.signatureValid())
      .map(value => value: Boolean)
    override val signatureAlgorithm: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signatureAlgorithm())
      .map(value => value: String)
    override val signatureDateTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signatureDateTime())
      .map(value => value: String)
    override val signatureKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signatureKeyId())
      .map(value => value: String)
    override val validationErrors: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityResponse
  ): zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse.ReadOnly =
    new Wrapper(impl)
}
