package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSettingsResponse(
    settings: Optional[zio.aws.auditmanager.model.Settings] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateSettingsResponse = {
    import UpdateSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateSettingsResponse
      .builder()
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.UpdateSettingsResponse.ReadOnly =
    zio.aws.auditmanager.model.UpdateSettingsResponse.wrap(buildAwsValue())
}
object UpdateSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UpdateSettingsResponse =
      zio.aws.auditmanager.model
        .UpdateSettingsResponse(settings.map(value => value.asEditable))
    def settings: Optional[zio.aws.auditmanager.model.Settings.ReadOnly]
    def getSettings
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Settings.ReadOnly] =
      AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateSettingsResponse
  ) extends zio.aws.auditmanager.model.UpdateSettingsResponse.ReadOnly {
    override val settings
        : Optional[zio.aws.auditmanager.model.Settings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value => zio.aws.auditmanager.model.Settings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateSettingsResponse
  ): zio.aws.auditmanager.model.UpdateSettingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
