package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAssessmentResponse(
    assessment: Optional[zio.aws.auditmanager.model.Assessment] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentResponse = {
    import UpdateAssessmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentResponse
      .builder()
      .optionallyWith(assessment.map(value => value.buildAwsValue()))(
        _.assessment
      )
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.UpdateAssessmentResponse.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentResponse.wrap(buildAwsValue())
}
object UpdateAssessmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UpdateAssessmentResponse =
      zio.aws.auditmanager.model
        .UpdateAssessmentResponse(assessment.map(value => value.asEditable))
    def assessment: Optional[zio.aws.auditmanager.model.Assessment.ReadOnly]
    def getAssessment
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Assessment.ReadOnly] =
      AwsError.unwrapOptionField("assessment", assessment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentResponse
  ) extends zio.aws.auditmanager.model.UpdateAssessmentResponse.ReadOnly {
    override val assessment
        : Optional[zio.aws.auditmanager.model.Assessment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessment())
        .map(value => zio.aws.auditmanager.model.Assessment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentResponse
  ): zio.aws.auditmanager.model.UpdateAssessmentResponse.ReadOnly = new Wrapper(
    impl
  )
}
