package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait ControlType {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.ControlType
}
object ControlType {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.ControlType
  ): zio.aws.auditmanager.model.ControlType = value match {
    case software.amazon.awssdk.services.auditmanager.model.ControlType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlType.STANDARD =>
      val r = Standard
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlType.CUSTOM =>
      val r = Custom
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.ControlType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlType =
      software.amazon.awssdk.services.auditmanager.model.ControlType.UNKNOWN_TO_SDK_VERSION
  }
  case object Standard extends zio.aws.auditmanager.model.ControlType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlType =
      software.amazon.awssdk.services.auditmanager.model.ControlType.STANDARD
  }
  case object Custom extends zio.aws.auditmanager.model.ControlType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlType =
      software.amazon.awssdk.services.auditmanager.model.ControlType.CUSTOM
  }
}
