package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.S3Url
import scala.jdk.CollectionConverters._
final case class ValidateAssessmentReportIntegrityRequest(
    s3RelativePath: S3Url
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityRequest = {
    import ValidateAssessmentReportIntegrityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityRequest
      .builder()
      .s3RelativePath(S3Url.unwrap(s3RelativePath): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityRequest.ReadOnly =
    zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityRequest
      .wrap(buildAwsValue())
}
object ValidateAssessmentReportIntegrityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityRequest =
      zio.aws.auditmanager.model
        .ValidateAssessmentReportIntegrityRequest(s3RelativePath)
    def s3RelativePath: S3Url
    def getS3RelativePath: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(s3RelativePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityRequest
  ) extends zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityRequest.ReadOnly {
    override val s3RelativePath: S3Url =
      zio.aws.auditmanager.model.primitives.S3Url(impl.s3RelativePath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityRequest
  ): zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityRequest.ReadOnly =
    new Wrapper(impl)
}
