package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.ControlSetName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAssessmentFrameworkControlSet(
    id: Optional[ControlSetName] = Optional.Absent,
    name: ControlSetName,
    controls: Iterable[
      zio.aws.auditmanager.model.CreateAssessmentFrameworkControl
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkControlSet = {
    import UpdateAssessmentFrameworkControlSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkControlSet
      .builder()
      .optionallyWith(
        id.map(value => ControlSetName.unwrap(value): java.lang.String)
      )(_.id)
      .name(ControlSetName.unwrap(name): java.lang.String)
      .controls(controls.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet
      .wrap(buildAwsValue())
}
object UpdateAssessmentFrameworkControlSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkControlSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet =
      zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet(
        id.map(value => value),
        name,
        controls.map { item =>
          item.asEditable
        }
      )
    def id: Optional[ControlSetName]
    def name: ControlSetName
    def controls: List[
      zio.aws.auditmanager.model.CreateAssessmentFrameworkControl.ReadOnly
    ]
    def getId: ZIO[Any, AwsError, ControlSetName] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, Nothing, ControlSetName] = ZIO.succeed(name)
    def getControls: ZIO[Any, Nothing, List[
      zio.aws.auditmanager.model.CreateAssessmentFrameworkControl.ReadOnly
    ]] = ZIO.succeed(controls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkControlSet
  ) extends zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet.ReadOnly {
    override val id: Optional[ControlSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetName(value))
    override val name: ControlSetName =
      zio.aws.auditmanager.model.primitives.ControlSetName(impl.name())
    override val controls: List[
      zio.aws.auditmanager.model.CreateAssessmentFrameworkControl.ReadOnly
    ] = impl
      .controls()
      .asScala
      .map { item =>
        zio.aws.auditmanager.model.CreateAssessmentFrameworkControl.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkControlSet
  ): zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet.ReadOnly =
    new Wrapper(impl)
}
