package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  AssessmentName,
  Timestamp,
  IamArn,
  UUID,
  NonEmptyString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DelegationMetadata(
    id: Optional[UUID] = Optional.Absent,
    assessmentName: Optional[AssessmentName] = Optional.Absent,
    assessmentId: Optional[UUID] = Optional.Absent,
    status: Optional[zio.aws.auditmanager.model.DelegationStatus] =
      Optional.Absent,
    roleArn: Optional[IamArn] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    controlSetName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.DelegationMetadata = {
    import DelegationMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.DelegationMetadata
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        assessmentName.map(value =>
          AssessmentName.unwrap(value): java.lang.String
        )
      )(_.assessmentName)
      .optionallyWith(
        assessmentId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.assessmentId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        roleArn.map(value => IamArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        controlSetName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.controlSetName)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.DelegationMetadata.ReadOnly =
    zio.aws.auditmanager.model.DelegationMetadata.wrap(buildAwsValue())
}
object DelegationMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.DelegationMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.DelegationMetadata =
      zio.aws.auditmanager.model.DelegationMetadata(
        id.map(value => value),
        assessmentName.map(value => value),
        assessmentId.map(value => value),
        status.map(value => value),
        roleArn.map(value => value),
        creationTime.map(value => value),
        controlSetName.map(value => value)
      )
    def id: Optional[UUID]
    def assessmentName: Optional[AssessmentName]
    def assessmentId: Optional[UUID]
    def status: Optional[zio.aws.auditmanager.model.DelegationStatus]
    def roleArn: Optional[IamArn]
    def creationTime: Optional[Timestamp]
    def controlSetName: Optional[NonEmptyString]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getAssessmentName: ZIO[Any, AwsError, AssessmentName] =
      AwsError.unwrapOptionField("assessmentName", assessmentName)
    def getAssessmentId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("assessmentId", assessmentId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.DelegationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRoleArn: ZIO[Any, AwsError, IamArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getControlSetName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("controlSetName", controlSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.DelegationMetadata
  ) extends zio.aws.auditmanager.model.DelegationMetadata.ReadOnly {
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val assessmentName: Optional[AssessmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessmentName())
        .map(value =>
          zio.aws.auditmanager.model.primitives.AssessmentName(value)
        )
    override val assessmentId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val status: Optional[zio.aws.auditmanager.model.DelegationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.auditmanager.model.DelegationStatus.wrap(value))
    override val roleArn: Optional[IamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.auditmanager.model.primitives.IamArn(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val controlSetName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlSetName())
        .map(value =>
          zio.aws.auditmanager.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.DelegationMetadata
  ): zio.aws.auditmanager.model.DelegationMetadata.ReadOnly = new Wrapper(impl)
}
