package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSettingsResponse(
    settings: Option[zio.aws.auditmanager.model.Settings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetSettingsResponse = {
    import GetSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetSettingsResponse
      .builder()
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetSettingsResponse.ReadOnly =
    zio.aws.auditmanager.model.GetSettingsResponse.wrap(buildAwsValue())
}
object GetSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetSettingsResponse =
      zio.aws.auditmanager.model
        .GetSettingsResponse(settings.map(value => value.asEditable))
    def settings: Option[zio.aws.auditmanager.model.Settings.ReadOnly]
    def getSettings
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Settings.ReadOnly] =
      AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetSettingsResponse
  ) extends zio.aws.auditmanager.model.GetSettingsResponse.ReadOnly {
    override val settings
        : Option[zio.aws.auditmanager.model.Settings.ReadOnly] = scala
      .Option(impl.settings())
      .map(value => zio.aws.auditmanager.model.Settings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetSettingsResponse
  ): zio.aws.auditmanager.model.GetSettingsResponse.ReadOnly = new Wrapper(impl)
}
