package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAccountStatusResponse(
    status: Option[zio.aws.auditmanager.model.AccountStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetAccountStatusResponse = {
    import GetAccountStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetAccountStatusResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetAccountStatusResponse.ReadOnly =
    zio.aws.auditmanager.model.GetAccountStatusResponse.wrap(buildAwsValue())
}
object GetAccountStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetAccountStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetAccountStatusResponse =
      zio.aws.auditmanager.model
        .GetAccountStatusResponse(status.map(value => value))
    def status: Option[zio.aws.auditmanager.model.AccountStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.AccountStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAccountStatusResponse
  ) extends zio.aws.auditmanager.model.GetAccountStatusResponse.ReadOnly {
    override val status: Option[zio.aws.auditmanager.model.AccountStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.auditmanager.model.AccountStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAccountStatusResponse
  ): zio.aws.auditmanager.model.GetAccountStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
