package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  EventName,
  EvidenceAttributeKey,
  AccountId,
  AWSServiceName,
  Timestamp,
  EvidenceAttributeValue,
  IamArn,
  UUID
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Evidence(
    dataSource: Option[String] = None,
    evidenceAwsAccountId: Option[AccountId] = None,
    time: Option[Timestamp] = None,
    eventSource: Option[AWSServiceName] = None,
    eventName: Option[EventName] = None,
    evidenceByType: Option[String] = None,
    resourcesIncluded: Option[Iterable[zio.aws.auditmanager.model.Resource]] =
      None,
    attributes: Option[Map[EvidenceAttributeKey, EvidenceAttributeValue]] =
      None,
    iamId: Option[IamArn] = None,
    complianceCheck: Option[String] = None,
    awsOrganization: Option[String] = None,
    awsAccountId: Option[AccountId] = None,
    evidenceFolderId: Option[UUID] = None,
    id: Option[UUID] = None,
    assessmentReportSelection: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Evidence = {
    import Evidence.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Evidence
      .builder()
      .optionallyWith(dataSource.map(value => value: java.lang.String))(
        _.dataSource
      )
      .optionallyWith(
        evidenceAwsAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.evidenceAwsAccountId)
      .optionallyWith(time.map(value => Timestamp.unwrap(value): Instant))(
        _.time
      )
      .optionallyWith(
        eventSource.map(value => AWSServiceName.unwrap(value): java.lang.String)
      )(_.eventSource)
      .optionallyWith(
        eventName.map(value => EventName.unwrap(value): java.lang.String)
      )(_.eventName)
      .optionallyWith(evidenceByType.map(value => value: java.lang.String))(
        _.evidenceByType
      )
      .optionallyWith(
        resourcesIncluded.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourcesIncluded)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (EvidenceAttributeKey.unwrap(
                key
              ): java.lang.String) -> (EvidenceAttributeValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        iamId.map(value => IamArn.unwrap(value): java.lang.String)
      )(_.iamId)
      .optionallyWith(complianceCheck.map(value => value: java.lang.String))(
        _.complianceCheck
      )
      .optionallyWith(awsOrganization.map(value => value: java.lang.String))(
        _.awsOrganization
      )
      .optionallyWith(
        awsAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        evidenceFolderId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.evidenceFolderId)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        assessmentReportSelection.map(value => value: java.lang.String)
      )(_.assessmentReportSelection)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Evidence.ReadOnly =
    zio.aws.auditmanager.model.Evidence.wrap(buildAwsValue())
}
object Evidence {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Evidence
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Evidence =
      zio.aws.auditmanager.model.Evidence(
        dataSource.map(value => value),
        evidenceAwsAccountId.map(value => value),
        time.map(value => value),
        eventSource.map(value => value),
        eventName.map(value => value),
        evidenceByType.map(value => value),
        resourcesIncluded.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attributes.map(value => value),
        iamId.map(value => value),
        complianceCheck.map(value => value),
        awsOrganization.map(value => value),
        awsAccountId.map(value => value),
        evidenceFolderId.map(value => value),
        id.map(value => value),
        assessmentReportSelection.map(value => value)
      )
    def dataSource: Option[String]
    def evidenceAwsAccountId: Option[AccountId]
    def time: Option[Timestamp]
    def eventSource: Option[AWSServiceName]
    def eventName: Option[EventName]
    def evidenceByType: Option[String]
    def resourcesIncluded
        : Option[List[zio.aws.auditmanager.model.Resource.ReadOnly]]
    def attributes: Option[Map[EvidenceAttributeKey, EvidenceAttributeValue]]
    def iamId: Option[IamArn]
    def complianceCheck: Option[String]
    def awsOrganization: Option[String]
    def awsAccountId: Option[AccountId]
    def evidenceFolderId: Option[UUID]
    def id: Option[UUID]
    def assessmentReportSelection: Option[String]
    def getDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getEvidenceAwsAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("evidenceAwsAccountId", evidenceAwsAccountId)
    def getTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("time", time)
    def getEventSource: ZIO[Any, AwsError, AWSServiceName] =
      AwsError.unwrapOptionField("eventSource", eventSource)
    def getEventName: ZIO[Any, AwsError, EventName] =
      AwsError.unwrapOptionField("eventName", eventName)
    def getEvidenceByType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("evidenceByType", evidenceByType)
    def getResourcesIncluded: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Resource.ReadOnly
    ]] = AwsError.unwrapOptionField("resourcesIncluded", resourcesIncluded)
    def getAttributes: ZIO[Any, AwsError, Map[
      EvidenceAttributeKey,
      EvidenceAttributeValue
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getIamId: ZIO[Any, AwsError, IamArn] =
      AwsError.unwrapOptionField("iamId", iamId)
    def getComplianceCheck: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("complianceCheck", complianceCheck)
    def getAwsOrganization: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsOrganization", awsOrganization)
    def getAwsAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getEvidenceFolderId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("evidenceFolderId", evidenceFolderId)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getAssessmentReportSelection: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("assessmentReportSelection", assessmentReportSelection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Evidence
  ) extends zio.aws.auditmanager.model.Evidence.ReadOnly {
    override val dataSource: Option[String] =
      scala.Option(impl.dataSource()).map(value => value: String)
    override val evidenceAwsAccountId: Option[AccountId] = scala
      .Option(impl.evidenceAwsAccountId())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val time: Option[Timestamp] = scala
      .Option(impl.time())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val eventSource: Option[AWSServiceName] = scala
      .Option(impl.eventSource())
      .map(value => zio.aws.auditmanager.model.primitives.AWSServiceName(value))
    override val eventName: Option[EventName] = scala
      .Option(impl.eventName())
      .map(value => zio.aws.auditmanager.model.primitives.EventName(value))
    override val evidenceByType: Option[String] =
      scala.Option(impl.evidenceByType()).map(value => value: String)
    override val resourcesIncluded
        : Option[List[zio.aws.auditmanager.model.Resource.ReadOnly]] = scala
      .Option(impl.resourcesIncluded())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.Resource.wrap(item)
        }.toList
      )
    override val attributes
        : Option[Map[EvidenceAttributeKey, EvidenceAttributeValue]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.auditmanager.model.primitives.EvidenceAttributeKey(
              key
            ) -> zio.aws.auditmanager.model.primitives
              .EvidenceAttributeValue(value)
          })
          .toMap
      )
    override val iamId: Option[IamArn] = scala
      .Option(impl.iamId())
      .map(value => zio.aws.auditmanager.model.primitives.IamArn(value))
    override val complianceCheck: Option[String] =
      scala.Option(impl.complianceCheck()).map(value => value: String)
    override val awsOrganization: Option[String] =
      scala.Option(impl.awsOrganization()).map(value => value: String)
    override val awsAccountId: Option[AccountId] = scala
      .Option(impl.awsAccountId())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val evidenceFolderId: Option[UUID] = scala
      .Option(impl.evidenceFolderId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val assessmentReportSelection: Option[String] =
      scala.Option(impl.assessmentReportSelection()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Evidence
  ): zio.aws.auditmanager.model.Evidence.ReadOnly = new Wrapper(impl)
}
